#ifndef _BJPEG_H_
#define _BJPEG_H_

enum { eThumbNever, eThumbKeepExisting, eThumbRegenerateExisting };

struct save_params {
	save_params():
		bRetainOriginalTime(FALSE),
		bOptimizeHuffman(TRUE),
		bSaveComments(TRUE),
		bSaveEXIF(TRUE),
		// Thumbnail
		iGenerateEXIFThumb(eThumbKeepExisting),
		iEXIFThumbSize(160),
		// Bitmap
		pBits(NULL),
		iBitmapHeight(0),
		iBitmapRowSize(0) {};
	BOOL bRetainOriginalTime;
	BOOL bOptimizeHuffman;
	BOOL bSaveComments;
	BOOL bSaveEXIF;
	// Thumbnail
	int iGenerateEXIFThumb;
	int iEXIFThumbSize;
	// Bitmap
	BYTE* pBits;
	int iBitmapHeight;
	int iBitmapRowSize;
	// Statistics (returned values)
	int iMCUsChanged;
	int iDCTsChanged;
};

interface IBJPEG : public IUnknown
{
public:
	virtual BOOL STDMETHODCALLTYPE ReadCoefficients(LPCSTR szFileName) = 0; 
	virtual void STDMETHODCALLTYPE ReleaseImage() = 0;
	virtual BOOL STDMETHODCALLTYPE IsLoaded() = 0;
	virtual int STDMETHODCALLTYPE GetWidth() = 0;
	virtual int STDMETHODCALLTYPE GetHeight() = 0;
	virtual int STDMETHODCALLTYPE GetMCUWidth() = 0;
	virtual int STDMETHODCALLTYPE GetMCUHeight() = 0;
	virtual BOOL STDMETHODCALLTYPE GetBitmap(BYTE* pBits, int iBMPRowSize) = 0;
	virtual BOOL STDMETHODCALLTYPE Save(LPCSTR szFileName, save_params* pParams) = 0;
	virtual BOOL STDMETHODCALLTYPE CreatePreview(LPCSTR szFileName, BYTE* pBits, int iThumbWidth,
		int iThumbHeight, int iBitmapWidth, BYTE iR, BYTE iG, BYTE iB,
		int* piImageWidth, int* piImageHeight) = 0;
	virtual BOOL STDMETHODCALLTYPE Crop(int iLeft, int iTop, int iRight, int iBottom) = 0;
	virtual BOOL STDMETHODCALLTYPE FlipH() = 0;
	virtual BOOL STDMETHODCALLTYPE FlipV() = 0;
	virtual BOOL STDMETHODCALLTYPE RotateLeft() = 0;
	virtual BOOL STDMETHODCALLTYPE RotateRight() = 0;
	virtual BOOL STDMETHODCALLTYPE Undo() = 0;

	virtual LPCSTR STDMETHODCALLTYPE Format(LPCSTR szFormat, BOOL bUseFileTime, LCID iLocale, LPCSTR szDateFormat, LPCSTR szTimeFormat) = 0;
	virtual USHORT STDMETHODCALLTYPE GetOrientation() = 0;
	virtual void STDMETHODCALLTYPE SetOrientation(USHORT iOrientation) = 0;
};

#endif //_BJPEG_H_
